﻿if (ScriptUI.environment.keyboardState.shiftKey) {
    function Overlay() {
        function step1(enabled, withDialog) {
            if (enabled != undefined && !enabled) {
                return;
            }
            var dialogMode = withDialog ? DialogModes.ALL : DialogModes.NO;
            var desc1 = new ActionDescriptor();
            var ref1 = new ActionReference();
            ref1.putClass(PSClass.Layer);
            desc1.putReference(PSString.Null, ref1);
            var desc2 = new ActionDescriptor();
            desc2.putString(PSKey.Name, "D&B Overlay");
            desc2.putEnumerated(PSKey.Mode, PSType.BlendMode, PSEnum.Overlay);
            desc2.putBoolean(PSKey.FillNeutral, true);
            desc1.putObject(PSKey.Using, PSClass.Layer, desc2);
            executeAction(PSEvent.Make, desc1, dialogMode);
        }

        function step2(enabled, withDialog) {
            if (enabled != undefined && !enabled) {
                return;
            }
            var dialogMode = withDialog ? DialogModes.ALL : DialogModes.NO;
            var desc1 = new ActionDescriptor();
            var ref1 = new ActionReference();
            ref1.putEnumerated(PSClass.Layer, PSType.Ordinal, PSEnum.Target);
            desc1.putReference(PSString.Null, ref1);
            var desc2 = new ActionDescriptor();
            desc2.putEnumerated(PSKey.Color, PSKey.Color, PSEnum.Blue);
            desc1.putObject(PSKey.To, PSClass.Layer, desc2);
            executeAction(PSEvent.Set, desc1, dialogMode);
        }
        step1();
        step2();
    }
    cTID = function(s) {
        return app.charIDToTypeID(s);
    };
    sTID = function(s) {
        return app.stringIDToTypeID(s);
    };
    Overlay.loadSymbols = function() {
        var dbgLevel = $.level;
        $.level = 0;
        try {
            PSConstants;
            return;
        } catch (e) {

        } finally {
            $.level = dbgLevel;
        }
        var needDefs = true;
        $.level = 0;
        try {
            PSClass;
            needDefs = false;
        } catch (e) {

        } finally {
            $.level = dbgLevel;
        }
        if (needDefs) {
            PSClass = function() {

            };
            PSEnum = function() {

            };
            PSEvent = function() {

            };
            PSForm = function() {

            };
            PSKey = function() {

            };
            PSType = function() {

            };
            PSUnit = function() {

            };
            PSString = function() {

            };
        }
        PSClass.Layer = cTID("Lyr ");
        PSEnum.Blue = cTID("Bl  ");
        PSEnum.Overlay = cTID("Ovrl");
        PSEnum.SoftLight = cTID("SftL");
        PSEnum.Target = cTID("Trgt");
        PSEvent.Make = cTID("Mk  ");
        PSEvent.Set = cTID("setd");
        PSKey.Color = cTID("Clr ");
        PSKey.FillNeutral = cTID("FlNt");
        PSKey.Mode = cTID("Md  ");
        PSKey.Name = cTID("Nm  ");
        PSKey.To = cTID("T   ");
        PSKey.Using = cTID("Usng");
        PSString.Null = sTID("null");
        PSType.BlendMode = cTID("BlnM");
        PSType.Ordinal = cTID("Ordn");
    };
    Overlay.loadSymbols();
    Overlay.main = function() {
        Overlay();
    };
    Overlay.main();
} else {
    if (app) {
        try {
            TexBos();
        } catch (e) {
            alert("请创建任意一个2分频。");
        }
    }

    function TexBos() {
        var ref1 = new ActionReference();
        ref1.putName(charIDToTypeID("Lyr "), "Texture_Boost");
        var desc1 = executeActionGet(ref1);
        var visible = desc1.getBoolean(stringIDToTypeID("visible"));
        if (visible === true) {
            var idHd = charIDToTypeID("Hd  ");
            var desc240 = new ActionDescriptor();
            var idnull = charIDToTypeID("null");
            var list84 = new ActionList();
            var ref206 = new ActionReference();
            var idLyr = charIDToTypeID("Lyr ");
            ref206.putName(idLyr, "Texture_Boost");
            list84.putReference(ref206);
            desc240.putList(idnull, list84);
            executeAction(idHd, desc240, DialogModes.NO);
        } else {
            var idShw = charIDToTypeID("Shw ");
            var desc239 = new ActionDescriptor();
            var idnull = charIDToTypeID("null");
            var list83 = new ActionList();
            var ref205 = new ActionReference();
            var idLyr = charIDToTypeID("Lyr ");
            ref205.putName(idLyr, "Texture_Boost");
            list83.putReference(ref205);
            desc239.putList(idnull, list83);
            executeAction(idShw, desc239, DialogModes.NO);
        }
    }
}